// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ MeshField.cpp ]		Auter : KENSUKE WATANABE
//														Data  : 2017/04/27
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2017/04/27
//
// ======== ======== ======== ======== ======== ======== ======== ========
// -------- -------- -------- -------- -------- -------- -------- --------
// CN[ht@C
// -------- -------- -------- -------- -------- -------- -------- --------
#include <math.h>
#include "main.h"
#include "scene3D.h"
#include "sceneField.h"
#include "sceneSkydome.h"
#include "manager.h"
#include "modeTitle.h"
#include "modeGame.h"
#include "texManager.h"
#include "camera.h"
#include "light.h"
#include "renderer.h"

float meshPosY[16 + 1][16 + 1] =
{
	{ -100.f, -100.f, -100.f, -100.f, -100.f, -100.f, -100.f, -100.f ,-100.f, -100.f, -100.f, -100.f, -100.f, -100.f, -100.f, -100.f, -100.f },
	{ -100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 100.f, -100.f },
	{ -100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, 100.f, -100.f },
	{ -100.f, -100.f, -100.f, -100.f, -100.f, -100.f, -100.f, -100.f ,-100.f, -100.f, -100.f, -100.f, -100.f, -100.f, -100.f, -100.f, -100.f }
};

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneField::Init( void )
{
	// Ńt@Cǂݍ & ʂ̐̎擾

	m_numFaceX = 16;
	m_numFaceZ = 16;

	SetPos(D3DXVECTOR3(0.f, 0.f, 0.f));		// W
	SetRot(D3DXVECTOR3(0.f, 0.f, 0.f));		// px
	SetScl(D3DXVECTOR3(1.f, 1.f, 1.f));		// g嗦
	SetSize(D3DXVECTOR3(1.f, 1.f, 1.f));		// TCY
	m_vecVtxNom.clear();						// _@
	m_numVtx = 0;								// Vtx
	m_numIndex = 0;								// CfbNX
	m_pIdxBuffer = nullptr;						// CfbNXobt@
	m_pVtxBuffer = nullptr;						// _obt@
	m_strFilePass.clear();						// eNX`̖O
}

//-----------------------------------------------------------------------------
// I
//-----------------------------------------------------------------------------
void CSceneField::Uninit(void)
{
	// CfbNXobt@̉
	if(m_pIdxBuffer != nullptr)
	{
		m_pIdxBuffer->Release();
		m_pIdxBuffer = nullptr;
	}

	// eNX̏I
	CScene3D::Uninit();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// XV
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneField::Update( void )
{
	VERTEX_3D* pVtx;	// obt@bN
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);
	for (int i = 0, max = m_vecVtxNom.size(); i < max; i++)
	{
		// _@̐ݒ
		pVtx[i].nom = m_vecVtxNom[i];
	}
	// bN̉
	m_pVtxBuffer->Unlock();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// |S`
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneField::Draw( void )
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	D3DXMATRIX mtxScl;					// gs
	D3DXMATRIX mtxRot;					// ]s
	D3DXMATRIX mtxPos;					// ss

	D3DXVECTOR3 pos = GetPos();
	D3DXVECTOR3 rot = GetRot();
	D3DXVECTOR3 scl = GetScl();

	// [h}gNX̍쐬
	D3DXMatrixIdentity(&m_mtxWorld);	// sPʍsɂ( g嗦1,0ŏ )
	D3DXMatrixIdentity(&mtxScl);		//
	D3DXMatrixIdentity(&mtxRot);		//
	D3DXMatrixIdentity(&mtxPos);		//

	// [hϊsݒ肵ĕϊ
	D3DXMatrixScaling(&mtxScl, scl.x, scl.y, scl.z);				// gs
	D3DXMatrixRotationYawPitchRoll(&mtxRot, rot.y, rot.x, rot.z);	// 
	D3DXMatrixTranslation(&mtxPos, pos.x, pos.y, pos.z);			// sړs

	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxScl);
	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxRot);
	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxPos);

	// foCXɃ[hϊsݒ
	pDevice->SetTransform(D3DTS_WORLD, &m_mtxWorld);

	// _tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_3D);

	// CfbNXԍfoCXɐݒ
	pDevice->SetIndices(m_pIdxBuffer);

	// eNX`pCvCɃZbg
	if(!m_strFilePass.empty())
	{
		pDevice->SetTexture(0, CManager::GetTexManager()->GetTexInterface(m_strFilePass));
	}else {pDevice->SetTexture(0, nullptr);}

	// _obt@foCX̃f[^ Xg[ɃoCh
	pDevice->SetStreamSource(0,	m_pVtxBuffer, 0, sizeof(VERTEX_3D));

	// v~eBu̐ݒ
	pDevice->DrawIndexedPrimitive(D3DPT_TRIANGLESTRIP, 0, 0, NUM_POLYGON, 0, m_numIndex - 2);
}

//-----------------------------------------------------------------------------
// _쐬
//-----------------------------------------------------------------------------
HRESULT CSceneField::SetVtx(LPDIRECT3DDEVICE9 pDevice)
{
	m_numVtx = (m_numFaceX + 1) * (m_numFaceZ + 1);							// _
	m_numIndex = (2 + 2 * m_numFaceX) * m_numFaceZ + (m_numFaceZ - 1) * 2;	// CfbNX(|S`掞ɕKvȒ_)

	// _obt@쐬--------------------------------
	if(FAILED(pDevice->CreateVertexBuffer(sizeof(VERTEX_3D) * m_numVtx,
		D3DUSAGE_WRITEONLY, FVF_VERTEX_3D, D3DPOOL_MANAGED, &m_pVtxBuffer, nullptr)))
	{
		return E_FAIL;
	}

	VERTEX_3D* pVtx;	// obt@bN
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);

	// 1ubN̕ƍ
	D3DXVECTOR3 size = GetSize();
	m_faceSize.x = size.x / m_numFaceX;
	m_faceSize.y = size.z / m_numFaceZ;

	// W
	D3DXVECTOR3 pos = GetPos();

	// W̐ݒ
	for(int nCntZ = 0; nCntZ <= m_numFaceZ; nCntZ++)
	{
		for(int nCntX = 0; nCntX <= m_numFaceX; nCntX++)
		{
			// W
			m_vecVtxPos.push_back(D3DXVECTOR3(m_faceSize.x * nCntX - size.x * 0.5f + pos.x,
												meshPosY[m_numFaceX - nCntX][m_numFaceZ - nCntZ] * size.y + pos.y,
												m_faceSize.y * (m_numFaceZ - nCntZ) - size.z * 0.5f + pos.z));
			pVtx[nCntZ * (m_numFaceX + 1) + nCntX].pos = m_vecVtxPos[nCntZ * (m_numFaceX + 1) + nCntX];

			// F
			pVtx[nCntZ * (m_numFaceX + 1) + nCntX].col = D3DCOLOR_RGBA(255, 255, 255, 255);

			// eNX`W
			pVtx[nCntZ * (m_numFaceX + 1) + nCntX].tex = D3DXVECTOR2(1.f * nCntX, 1.f * nCntZ);
		}
	}
	
	// _@̐ݒ
	for (int nCntZ = 0; nCntZ <= m_numFaceZ; nCntZ++)
	{
		for (int nCntX = 0; nCntX <= m_numFaceX; nCntX++)
		{
			if (nCntZ == 0 || nCntZ == m_numFaceZ || nCntX == 0 || nCntX == m_numFaceX)
			{
				m_vecVtxNom.push_back(D3DXVECTOR3(0.f, 1.f, 0.f));
				continue;
			}

			// _@vZ
			D3DXVECTOR3 dirX, dirZ;
			D3DXVECTOR3 nomX, nomZ;

			int prevX = (nCntZ) * (m_numFaceX + 1) + (nCntX - 1);
			int nextX = (nCntZ) * (m_numFaceX + 1) + (nCntX + 1);
			int prevZ = (nCntZ - 1) * (m_numFaceX + 1) + (nCntX);
			int nextZ = (nCntZ + 1) * (m_numFaceX + 1) + (nCntX);

			dirX = m_vecVtxPos[nextX] - m_vecVtxPos[prevX];
			dirZ = m_vecVtxPos[prevZ] - m_vecVtxPos[nextZ];
			nomX.x = -dirX.y;
			nomX.y = dirX.x;
			nomX.z = 0.f;
			nomZ.x = 0.f;
			nomZ.y = dirZ.z;
			nomZ.z = -dirZ.y;

			D3DXVECTOR3 nom = nomX + nomZ;
			D3DXVec3Normalize(&nom, &nom);
			m_vecVtxNom.push_back(nom);

			// _@̐ݒ
			pVtx[(nCntZ) * (m_numFaceX + 1) + (nCntX)].nom = m_vecVtxNom[(nCntZ) * (m_numFaceX + 1) + (nCntX)];
		}
	}

	// bN̉
	m_pVtxBuffer->Unlock();

	// CfbNXobt@쐬--------------------------------
	if (FAILED(pDevice->CreateIndexBuffer(
		sizeof(WORD) * m_numIndex,		// obt@
		D3DUSAGE_WRITEONLY,				// gptO
		D3DFMT_INDEX16,					// Kvȃobt@
		D3DPOOL_MANAGED,				// ̊Ǘ@
		&m_pIdxBuffer,
		nullptr)))
	{
		return E_FAIL;
	}

	WORD *pIdx;			// obt@bN
	m_pIdxBuffer->Lock(0, 0, (void**)&pIdx, 0);

	int nCnt = 0;
	for (int nCntY = 0; nCntY < m_numFaceZ; nCntY++)
	{
		if (nCntY != 0)	// ԏ߂Ȃ
		{
			// _ł
			pIdx[nCnt] = static_cast<WORD>((m_numFaceX + 1) * nCntY + (m_numFaceX + 1));
			nCnt++;
		}
		// 2_ł(O, )
		pIdx[nCnt] = static_cast<WORD>((m_numFaceX + 1) * (nCntY + 1));
		nCnt++;
		pIdx[nCnt] = static_cast<WORD>((m_numFaceX + 1) * nCntY);
		nCnt++;

		for (int nCntX = 0; nCntX < m_numFaceX; nCntX++)
		{
			// 2_ł(O, )
			pIdx[nCnt] = static_cast<WORD>(((m_numFaceX + 1) * (nCntY + 1)) + (nCntX + 1));
			nCnt++;
			pIdx[nCnt] = static_cast<WORD>((m_numFaceX + 1) * nCntY + (nCntX + 1));
			nCnt++;
		}
		if (nCntY != m_numFaceZ - 1)	// ŌザȂ
		{
			// _ł
			pIdx[nCnt] = static_cast<WORD>(m_numFaceX + (nCntY * (m_numFaceX + 1)));
			nCnt++;
		}
	}

	//bN̉
	m_pIdxBuffer->Unlock(); 

	return NOERROR;
}

float CSceneField::GetHeight(D3DXVECTOR3 pos, bool *hit)
{
	D3DXVECTOR3 v12, v20, v01;
	D3DXVECTOR3 nom; 
	D3DXVECTOR3 p0, p1, p2, p3;
	float y;

	// 𒲂ׂ 
	for (int i = 0, end = m_vecVtxPos.size(); i < end; i++)
	{
		if (i > (m_numFaceX + 1) * (m_numFaceZ) - 2){ continue; }

		p0 = m_vecVtxPos[i];
		p1 = m_vecVtxPos[i + 1];
		p2 = m_vecVtxPos[i + (m_numFaceX + 1)];
		p3 = m_vecVtxPos[i + (m_numFaceX + 1) + 1];

		// 3̃xNg̓
		if (TriangleCloss(pos, p0, p2, p3, &nom))
		{
			if (nom == nullptr)continue;
			y = p0.y - ((pos.x - p0.x) * nom.x + (pos.z - p0.z) * nom.z) / nom.y;
			if (hit)*hit = true;
			return y;
		}

		// 3̃xNg̓
		if (TriangleCloss(pos, p0, p3, p1, &nom))
		{
			if (nom == nullptr)continue;
			y = p0.y - ((pos.x - p0.x) * nom.x + (pos.z - p0.z) * nom.z) / nom.y;
			if(hit)*hit = true;
			return y;
		}
	}
	if(hit)*hit = false;
	return 0.f;
}

bool CSceneField::TriangleCloss(D3DXVECTOR3 pos, D3DXVECTOR3 p0, D3DXVECTOR3 p1, D3DXVECTOR3 p2, D3DXVECTOR3 *nom)
{
	D3DXVECTOR3 v01 = p0 - p1;
	D3DXVECTOR3 v12 = p1 - p2;
	D3DXVECTOR3 v20 = p2 - p0;
	D3DXVECTOR3 vpxp0 = pos - p0;
	D3DXVECTOR3 vpxp1 = pos - p1;
	D3DXVECTOR3 vpxp2 = pos - p2;

	D3DXVECTOR3 vc0;
	D3DXVec3Cross(&vc0, &v01, &vpxp0);
	if (vc0.y >= 0.f)
	{
		D3DXVec3Cross(&vc0, &v12, &vpxp1);
		if (vc0.y >= 0.f)
		{
			D3DXVec3Cross(&vc0, &v20, &vpxp2);
			if (vc0.y >= 0.f)
			{
				// ʖ@
				D3DXVECTOR3 vv1 = v12 - v20;
				D3DXVECTOR3 vv2 = v01 - v12;
				D3DXVec3Cross(nom, &vv1, &vv2);
				D3DXVec3Normalize(nom, nom);
				return true;
			}
		}
	}
	if(nom != nullptr)nom = nullptr;
	return false;
}

// -------- -------- -------- -------- -------- -------- -------- --------
// 쐬
// -------- -------- -------- -------- -------- -------- -------- --------
CSceneField *CSceneField::Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const D3DXVECTOR3 &size, const std::string &strFilePass)
{
	// CSceneField̐
	CSceneField *pSceneField;
	pSceneField = new CSceneField();
	pSceneField->Init();

	pSceneField->SetPos(pos);
	pSceneField->SetRot(rot);
	pSceneField->SetSize(size);
	pSceneField->m_strFilePass = strFilePass;

	// _ݒ
	pSceneField->SetVtx(CRenderer::GetDevice());
	
	// eNX`̃Zbg
	CManager::GetTexManager()->SetTex(strFilePass);

	return pSceneField;
}
